/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Pose;
import com.jme3.animation.Track;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.FloatBuffer;

@Deprecated
public final class PoseTrack
implements Track {
    private int targetMeshIndex;
    private PoseFrame[] frames;
    private float[] times;

    public PoseTrack(int targetMeshIndex, float[] times, PoseFrame[] frames) {
        this.targetMeshIndex = targetMeshIndex;
        this.times = times;
        this.frames = frames;
    }

    public PoseTrack() {
    }

    private void applyFrame(Mesh target, int frameIndex, float weight) {
        PoseFrame frame = this.frames[frameIndex];
        VertexBuffer pb = target.getBuffer(VertexBuffer.Type.Position);
        for (int i = 0; i < frame.poses.length; ++i) {
            Pose pose = frame.poses[i];
            float poseWeight = frame.weights[i] * weight;
            pose.apply(poseWeight, (FloatBuffer)pb.getData());
        }
        pb.updateData(pb.getData());
    }

    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
    }

    public float getLength() {
        return this.times == null ? 0.0f : this.times[this.times.length - 1] - this.times[0];
    }

    public PoseTrack clone() {
        try {
            PoseTrack result = (PoseTrack)super.clone();
            result.times = (float[])this.times.clone();
            if (this.frames != null) {
                result.frames = new PoseFrame[this.frames.length];
                for (int i = 0; i < this.frames.length; ++i) {
                    result.frames[i] = this.frames[i].clone();
                }
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule out = e.getCapsule(this);
        out.write(this.targetMeshIndex, "meshIndex", 0);
        out.write(this.frames, "frames", null);
        out.write(this.times, "times", (float[])null);
    }

    public void read(JmeImporter i) throws IOException {
        InputCapsule in = i.getCapsule(this);
        this.targetMeshIndex = in.readInt("meshIndex", 0);
        this.times = in.readFloatArray("times", null);
        Savable[] readSavableArray = in.readSavableArray("frames", null);
        if (readSavableArray != null) {
            this.frames = new PoseFrame[readSavableArray.length];
            System.arraycopy(readSavableArray, 0, this.frames, 0, readSavableArray.length);
        }
    }

    public static class PoseFrame
    implements Savable,
    Cloneable {
        Pose[] poses;
        float[] weights;

        public PoseFrame(Pose[] poses, float[] weights) {
            this.poses = poses;
            this.weights = weights;
        }

        public PoseFrame() {
        }

        public PoseFrame clone() {
            try {
                PoseFrame result = (PoseFrame)super.clone();
                result.weights = (float[])this.weights.clone();
                if (this.poses != null) {
                    result.poses = new Pose[this.poses.length];
                    for (int i = 0; i < this.poses.length; ++i) {
                        result.poses[i] = this.poses[i].clone();
                    }
                }
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        public void write(JmeExporter e) throws IOException {
            OutputCapsule out = e.getCapsule(this);
            out.write(this.poses, "poses", null);
            out.write(this.weights, "weights", (float[])null);
        }

        public void read(JmeImporter i) throws IOException {
            InputCapsule in = i.getCapsule(this);
            this.weights = in.readFloatArray("weights", null);
            Savable[] readSavableArray = in.readSavableArray("poses", null);
            if (readSavableArray != null) {
                this.poses = new Pose[readSavableArray.length];
                System.arraycopy(readSavableArray, 0, this.poses, 0, readSavableArray.length);
            }
        }
    }
}

